

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <string.h>

#include "../include/ms.h" 
#include "../include/matrix.h"
#include "../include/hnav.h"   





main( argc, argv )
     int argc;
     char *argv[];
{
  TapeHeap heapbuf;
  TapeHeap *heap=&heapbuf;

  FILE *fi;
  FILE *fo;

  fi = fopen( argv[1], "r" );
  fo = fopen( argv[2], "w" );

  printf(" testread \n" ); 

  quickJPLtoHeaderHeap( fi, heap ); 

  printf(" the heap header info: \n" );
  dumpEmptyHeap( fo, heap ); 


}

int 
quickJPLtoHeaderHeap( fi, heap )
     FILE *fi;
     TapeHeap *heap;
{
  char *line;
  char *s;
  char linebuf[125];
  int success;
  int groupNumber; 
  int i;            /* index to count tape-structure entries */ 
  int k;            /* loose index */ 
  int ent[20];      /* read entries from the header file group 1050 */ 
  TapeStructure *seven;
  int recordSize;
  int nbodies;
  double jdStartEpoch;
  double jdEndEpoch; 
  int ephemerisNumber; 
  double recordDuration; 
  int fiveSize; 
  char name[10][8]; /* names for group 5 */ 
  double dataEntry[3];    /* double float numbers to be read in */
  
  /* ---------------------------------------------------------------- */ 
  /* get group 4 info */ 
  gotoGroup( fi, 1030 );
  
  line = ephemline( fi );
  success = sscanf( line, " %le %le %le", 
		   &jdStartEpoch, &jdEndEpoch, &recordDuration ); 
  /* group 4: */ 
  heap->groupFour.earliestDate = jdStartEpoch;
  heap->groupFour.latestDate   = jdEndEpoch;
  heap->groupFour.recordLength = recordDuration; 
  heap->groupFour.recordInterval = heap->groupFour.recordLength;
  /*   heap->groupFour.numberOfBodies is set below */ 
  heap->groupFour.versionNumber = 0.;

  rewind( fi );
  for ( line=ephemline(fi); line!=NULL; line=ephemline(fi) )
    {
      success = sscanf( line, "JPL Planetary Ephemeris DE%d/", &ephemerisNumber );
      if (success)
	{
	  heap->groupFour.versionNumber = ephemerisNumber;
	  break;
	}
    }

  /* ---------------------------------------------------------------- */ 
  /* groups 5 and 6 -- the parameters of the integration: */ 

  /* first zero them out --  we may not find any data in the header file: */ 
  for( i=0; i<NAMELENGTH; ++i)
    {
      heap->groupSix[i] = (double) i;
      strcpy( heap->groupFive[i], "void" ); 
    }
  heap->size56 = NAMELENGTH; 

  rewind( fi ); 
  gotoGroup( fi, 1040 );

  line = ephemline( fi );
  success = sscanf( line, " %d", &fiveSize );
  if (success)
    {
      for (i=0; i<fiveSize; )
	{
	  line = ephemline( fi );
	  success = sscanf( line, " %s %s %s %s %s %s %s %s %s %s", 
			   &name[0], &name[1], &name[2], &name[3], &name[4],
			   &name[5], &name[6], &name[7], &name[8], &name[9] ); 
	  for( k=0; k<success; ++k )
	    {
	      strcpy( heap->groupFive[i], name[k] );
	      ++i;
	    }
	}
    }
  rewind( fi ); 
  gotoGroup( fi, 1041 );

  line = ephemline( fi );
  success = sscanf( line, " %d", &fiveSize );
  if (success)

    {
      for (i=0; i<fiveSize; )
	{
	  line = ephemline( fi );
	  for(s=line; *s != '\0'; ++s)   /* convert from Fortran double notation */
	    if ( *s == 'D' ) *s = 'e';   /* to C double-float notation */ 
	  success = sscanf( line, " %le %le %le", 
			   &dataEntry[0], &dataEntry[1], &dataEntry[2] );
	  for(k=0; k<success; ++k)
	    {
	      heap->groupSix[i] = dataEntry[k];
	      ++i;
	    }
	}

    }

  /* ---------------------------------------------------------------- */ 
  printf(" in quickJPLtoHeaderHeap, looking for group 7: \n" ); 
  seven = &(heap->groupSeven);

  /* skip to the last header group, the structure information: */ 
  gotoGroup( fi, 1050 ); 


  /* ---------------------------------------------------------------- */ 
  printf(" about to read the group-7 lines \n" ); 
  /* read the three lines of structure info: */ 
  line = ephemline( fi ); 
  success = sscanf( line, " %d %d %d %d %d %d %d %d %d %d %d %d %d", 
		   &ent[0], &ent[1], &ent[2], &ent[3],
		   &ent[4], &ent[5], &ent[6], &ent[7],
		   &ent[8], &ent[9], &ent[10], &ent[11],
		   &ent[12] ); 

  /* set number of bodies */
  nbodies = success;
  printf(" got %d as the number of bodies  \n", nbodies ); 
  heap->groupFour.numberOfBodies = nbodies; 

  for( i=0; i<success; ++i)
    seven->first[i] = ent[i]-1; /* #### check the offset !!!! */ 
  for( i=0; i<success; ++i)
    printf(" seven->first[%d] = %d \n", i, seven->first[i] ); 

    
  line = ephemline( fi ); 
  printf("%s\n", line ); 
  success = sscanf( line, " %d %d %d %d %d %d %d %d %d %d %d %d %d", 
		   &ent[0], &ent[1], &ent[2], &ent[3],
		   &ent[4], &ent[5], &ent[6], &ent[7],
		   &ent[8], &ent[9], &ent[10], &ent[11],
		   &ent[12] ); 
  printf(" success = %d \n", success ); 

  for( i=0; i<success; ++i)
    heap->groupSeven.ncoeffs[i] = ent[i]; 
  for( i=0; i<success; ++i)
    printf(" heap->groupSeven.ncoeffs[%d] = %d \n",
	   i, heap->groupSeven.ncoeffs[i] ); 
    
  line = ephemline( fi ); 
  printf("%s\n", line ); 
  success = sscanf( line, " %d %d %d %d %d %d %d %d %d %d %d %d %d", 
		   &ent[0], &ent[1], &ent[2], &ent[3],
		   &ent[4], &ent[5], &ent[6], &ent[7],
		   &ent[8], &ent[9], &ent[10], &ent[11],
		   &ent[12] ); 

  printf(" about to set heap->groupSeven: \n"); 
  for( i=0; i<success; ++i)
    heap->groupSeven.nintervals[i] = ent[i]; 
  for( i=0; i<success; ++i)
    printf(" heap->groupSeven.nintervals[%d] = %d \n",
	   i, heap->groupSeven.nintervals[i] ); 
    
  recordSize = getRecordLength( seven ); 
  printf(" recordSize = %d \n", recordSize ); 

  /* ---------------------------------------------------------------- */ 
  strcpy( heap->catfile, "no-catfile-yet" );  

  printf(" jdStart = jdEnd = 0. \n" ); 
  heap->jdStart = 2451545.0;
  heap->jdEnd   = 2451545.0; 
  heap->data[0] = heap->jdStart;
  heap->data[1] = heap->jdEnd; 

  printf(" setting data to dummy values \n"); 
  for( i=0; i<recordSize; ++i)
    heap->data[i] = (float) i ; 

  /* now set heap->index[]...: */ 
  printf(" about to call orderHeap() \n"); 
  orderHeap( heap ); 

}



int 
gotoGroup( fi, target )
     FILE *fi; 
     int target;
{
  char *line; 
  int success;
  int groupNumber;

  while( 1 ) 
  {
    line = ephemline( fi ); 
    printf("%s\n", line ); 
    if (line == NULL)
      {
	printf(" unexpected EOF; quitting \n");
	exit(1);
      }
    success = sscanf( line, "GROUP %d", &groupNumber ); 
    if (success != 1)
      continue;
    printf(" found Group %d \n", groupNumber ); 
    if (groupNumber == target )
      break;
    printf(" (keep looking) \n"); 
  }

  return groupNumber; 

}
