/* you MUST #include matrix.h BEFORE this header file !!!! */ 

/*
 * formerly navconst.h
 * 
 * astronomical constants definitions
 * 
 * copyright 1988-1995 Andrew P. Porter
 * Modified to remove many dependencies GGP 1990
 */

/* ---------------------------------------------------------------- */
/* constants:	 */

#undef PI
#define PI     3.141592653589793238462643 	/* Abramowitz and Stegun, p. 3 */
#undef PI2
#define PI2       6.283185307179586476925287
#define PIhalf    1.570796326794896619231322
#define TORADIANS (PI2/360.)	                /* PI2/360. 	*/
#define TODEGREES (360./PI2) 	                /* 360./PI2	*/ 

#define PARACRIT 1.e-13		/* closeness to (eccentricity = 1.0) 
				   that is declared to define a parabola */ 
#define NINETEEN_EIGHTY_EIGHT 2447160.5		/* Julian day, 1988/01/01.0 */
/*
 * The next is the number of seconds from start of 1970 (unix time)
 * to start of 1988
 */
#define UNIXTIME_1988 567993600 /* unix time at start of 1988, 
				   seconds since 1970.0 */ 

#define eccEarth 0.08182	/* eccentricity of the earth's surface */
                                /* source = Allen, p. 112	*/
#define eqRad 6378164.  	/* equatorial radius, meters; Allen, p. 112 */
#define polRad 6356779.		/* earth's polar radius, meters; Allen, p. 112 */
#define LITTLE_G 9.80621	/* units m/sec^2, 
				   grav acceleration at earth's surface */ 
#define EARTH_ROTATION 7.2921151467e-5
				/*    2*PI* reciprocal of 86164.09055 	   */
                                /*       (mean seconds per sidereal day)   */
                                /* from AstAlmanac 1984, p. S15 */
                                /* differs slightly from DOA TN 88-02, but */
				/* they precess the equinox */ 
                                /* they do not have confidence in this     */
				/* many figures of accuracy */
#define SIDEREALDAY 86164.09055 /* mean solar seconds per sidereal day */
#define SECSPERDAY 86400.0	/* seconds per any kind of day */
#define CIVILDAY 86636.55536	/* mean sidereal seconds per solar day */
#define LIGHTSPEED 2.9979250e8	/* Allen, p. 13 (M/SEC) */
/* ---------------------------------------------------------------- */
#define BIG_G 6.67259e-11	/* Physics Today, Aug 1987 */
				/* DOA TN 88/02 (Astrodynamic Standards) */
#define MU 3.986005e14		/* AstAlmanac88, p. K6; differs slightly */
				/* from Allen, p. 112 */
                                /* == WGS84 value, @ DOA TN 88/02, p. 23;*/
				/* includes mass of atmosphere */
#define E_MASS (MU / BIG_G)	/* earth mass, kg; MG is known better    */
				/* than M or G */
#define SUN_MU 1.32712438e20	/* G*Sun-mass; 
				   better known than G or Sun-mass; MKS units */
                                /* Astronomical Almanac, p. K6 
				   (1995 and some previous editions) */ 

#define SUN_MASS  (SUN_MU / BIG_G)
				/* sun's mass, kg, AstAlmanac88, p. K6 */
#define MUAD (SUN_MU*86400.*86400/(AU*AU*AU))
                                /* sun mu, in AU-day units */ 

#define RP_REFLECT 1.5		/* rad pressure reflection constant */
				/* 1 = black body, 2 = total reflection */
#define SOLARPOYNTING 1395.0	/* watts/meter^2 at Earth orbit */
#define RADPRESSURE (RP_REFLECT * SOLARPOYNTING / LIGHTSPEED)
				/* Kg/(m-sec^2)	*/
#define DRAGCOEF 2.0		/* atmospheric drag */
#define AU 149.59787068e9	/* Newhall, Standish, Williams, 
				   Astronomy and Astrophysics 125 (1983) 150 */
		/* Astronomical Unit (meters), 1988 Almanac, p. K5 is 149.600e9 */
#define GAUSS_GRAV 0.01720209895
				/* gaussian gravitational constant,*/
				/* Astronomical Almanac 1988, p. K5 */
/* the orbital elements of the earth-sun system:
 *     (osculating elements can be found on p. E4 of AstAlmanac88; 
 *      these are good to 1 part in 1000, usually 10,000. 
 */	
#define EARTH_SEMAJAX 149.6e9	/* 149.6 e6 kilometers; */
#define EARTH_ECC 0.016722	/* ref Allen, p. 140	*/
#define EARTH_ARG 1.79594380	/* mean longitude of perihelion @ */
				/* AstAlmanac88, p. E3 */
                                /* (102.9 degrees, converted to radians) */	
#define EARTH_NODE 0.;		/* definition: first point of Ares === 0. */
#define EARTH_INCL 0.;
#define EARTH_PERITIME 345600.  /* January 4, 1988, 0 hours, 
				   in seconds past 1988.0;  */
				/* Astronomical Almanac 1988, p. A9 */
#define J4 (-1.65597e-6) 	/* (-2.03e-6) 
				   leading coefficients in earth's grav field */
#define J2 1.082616e-3 		/* (1.082629e-3) 
				   expansion in cylindrical harmonics */
#define J3 (-.253881e-5) 	/* (-2.39e-6) */

#define MOON_MU   (0.01230002*MU)
#define MOON_MASS (0.01230002*E_MASS)
				/* Astronomical Almanac 1988, p. K6 */
				/* compare RMGreen, p. 172 */
#define MOON_SEMAJAX 3.84401e8	/* meters; ref Allen, p. 147 ("mean distance") */
#define MOON_ECC 0.0549		/* Allen, p. 147 */
#define MOON_INCL (5.1453964*TORADIANS)
				/* RMGreen, p. 172, AstAlmanac88, p. D2 */ 

#define MOON_PERITIME 1.630800e6
				/* 88/01/19, 21 hours: 
				   Astronomical Almanac 1988, p. A9 */

#define EQUATECCLIP (23.4392911*TORADIANS)
				/* inclination of earth's equator to */
				/* eccliptic (p. K6) */
#define LONGD_GRENW_1989 (15*(6 + 42./60. + 29.7644/3600.)*TORADIANS)
			/* cf. 1989 almanac, p. B8 */
#define LONGD_GRENW_1990 (15*(6 + 41./60. + 32.7920/3600.)*TORADIANS)
			/* cf. 1989 almanac, p. B8 */
    /*
     * The last, 1.756... radians, is (was) longitude of Greenwich
     * at 0h UT 1989/01/01 
     * at 1989/01/01 0h UT1 (See Ast Almanac 1989, p. B8:)
     * the GHA of the apparent Equinox = 6h 42m 29.7644s == 6.70826789 h 
     *						= 100.6240183 degrees
     *					== celestial longitude of greenwich 
     *					== 1.756220426 radians
     */




/*
 * formerly nav.h
 * 
 * mostly declarations for Keplerian orbit calculations; 
 * 	a few routines have in mind earth-satellite applications
 * copyright 1988 Andrew P. Porter
 */

typedef struct orbit
{
    double	o_mass;		/* kg !!!! */
    double	o_eccen;	/* eccentricity */
    double 	o_periTime;	/* time of perigee passage, seconds; zero of time is arbitrary  */
    double	o_axis;		/* meters; ell./hyperb: semimajor axis; 
				   but semi-parameter for parabola */
                                /* all angle units are radians */ 
    EulerRot	o_er;		/* maps from orbital plane coords to firmament coords */
    double 	o_refTime;	/* time at which orbiter has mean anomaly o_refAnomaly */
    double 	o_refAnomaly;	/* mean anomaly at o_refTime */
} Orbit;



/* ----------------------------------------------------------------
 * functions
 * ----------------------------------------------------------------
 */

/* these are in navMain.c: */
double navPerigeeTime();
double navAnomalyToTime();
void navKepler();
void navOrbitToPosVel(); 
void navPosition();
void navAnomalyToPosition();
double navTrueAnomaly(); 
double navFindMeanAnomaly();
double navMeanAnomaly();
double navFindEccentricAnomaly();
double navMeanToEccentricAnomaly();
double ekepl1(); 
double shkepl();
double shmkep(); 
double cuberoot(); 
double navFindTrueAnomaly();
double navEccentricToTrueAnomaly();
double navTrueToEccentricAnomaly();
double navEccToMeanAnomaly();
void navVelocity(); 
void navLocalVertical();
double navMeanMotion();
double parabolicRate(); 
double navRefAnomaly();
void navResetPeriTime();
void shiftRefTime(); 
double barkersEquation(); 
double parabolicTrueToMeanAnomaly(); 


/* in orbutili.c */
void copyOrbit(); 
double howBad();  	
void diffOrbit(); 
int equalOrbits(); 
int OKOrb(); 
void testRotateOrbit(); 
void rotateOrbit(); 
void rotateOrbitVectors(); 	

/* ---------------------------------------------------------------- */ 
/* these are in navAncilla.c: */
double navGeocentLat();
double navGeodetLat();
void navCheckLat(); 

double 	navGeocentAlt();
double 	navGeodetAlt();
double 	navGeocentLong();		/* these two routines */
double 	navCelestialLong();		/* are the same       */
double 	navGeodetLong();

double 	navEarthRadius();
double 	navEarthRadCurv();

Orbit 	*navOrbitSet();
Orbit 	*navInitialElements();
void 	 testxel();
Orbit 	*Xelements();
int 	 Xposvel();

double 	uncertainty();
double 	gaussianNoise(); 
void 	noisetest(); 	
double 	hohmann(); 	
void 	hyperTest(); 

double  testSolution(); 

/* in printers.c */ 
void dumpOrbit(); 
void fdumpOrbit(); 
void printOrbit(); 
void crash(); 			
int testRVOrbit();  		
int  RVOrbitTester(); 		


/* end of former nav.h */

/* former almanac.h
 * prototypes for almanac subroutines
 */

/* these next were used in apparent.c;
 * to see where, search on WhichPositionData and data->flag 
 * ORBITS --> source of positions is an Orbit 
 * TABLES --> source of positions is a set of JPL ephemeris files: 
 */ 
#define ORBITS 0
#define TABLES 1



/* this is used in calling apparentPlanetPosition(): */ 
typedef struct whichpositiondata
{
    int flag;		/* whether to use catfile or orb */ 
    int body;		/* which planet? */ 
    char *catfile;
    Orbit *orb;
} WhichPositionData; 

void apparentPlanetPosition( WhichPositionData *data, double utime, Coord3d *position ); 

/* possibly deleted, lost: */ 
void ecclipticToEquatorial();

/* used in exorbs.c */ 
void orbitUnits(); 

/* planetx.c */
void planetx(); 

/* precnuta.c */
void  nutationMatrix();
void precessionMatrix();
void  almanacGreenNutation();
void GreenNutations();
void greennu(); 
void greennod(); 
void gnod(); 

/* coortran.c */ 
void eclipticMatrix(); 
void toEcliptic();
void toEccliptic(  double jd, Coord3d *vector ); 
void toEquatorial( double jd, Coord3d *vector ); 
double  almanacMeanObliquity();
void almanacEcliptic();
double meanObliquity(); 
void ecclipticPole();
void  eclipticPole();
void equatorialPole(); 
void cliptoquat();
void almanacEquinox();
void almanacEquator();

/* in babyloni.c */
char *hourms();
char *degms(); 
void printDegMin();
void printHoursMS();
void radToHMS();
void printDegsMS();
void radToHMS();
void printHoursMS();

/* sorry 'bout the mispelling; its set in concrete now: */ 
#define toEcliptic toEccliptic

/* gmstgast.c: */
double GMST();
double GAST();

/* in apparent.c: */
void almanacPlanetPosition();
void usnoAbberation();
void greenAberration();
void quatPos();

/* in precnuta.c */ 
void rm_green_zeta();
void usnoPrecess();
void usnoNutate();
void etilt();

/* in sunmoon.c */ 
void almanacMoonPosition();
void moonPosition();
void moonRadec();
void ecclipticMoon();
void fundamentalArguments();
void sunRadec();
void sunPosition();
void MontenbruckMoon();
double tdt_ut();
void earthmoonToEarth();

/* this duplicates the former fundargs.h   
 * sources: RM Green, _Spherical Astronomy_, p. 172;
 * 	Astronomical Almanac, p. d2 and other places
 */
extern     double   meanMoonLongitude;	/* L' in Green's notation (and that of AstAlmanac88, p. D2) */
extern     double   meanMoonNode;	/* Omega, in AstAlmanac88 */
extern     double   meanMoonArgument;	/* F, = L' - Omega  (measured from asc.node) */
extern     double   moonMeanAnomaly;	/* M' 		    (measured from perigee)  */
extern     double   sunMeanAnomaly;	/* M  */
extern     double   meanElongation;	/* D  */
extern     double   moonPerigeeArgument; /* Gamma', in AstAlmanac88, p. D2 */ 
extern     double   meanSunLongitude;   /* L, acc. to p. D2 of the almanac */
extern     double   Obliquity;		/* obliquity of equator and eccliptic */
void fundamentalArguments();  

/* former calendar.h, prototypes for routines in calendar.c / calendar.o */

/* in calendar.c */ 
char *unixToCalendar();
char *doubleToDate();
double calendarDateToJulian();
double xjdnow(); 

char *calendarJulianToDate();
char *fvfJulianToDate(); 

double calendarUnixToJulian();
double calendarJulianToUnix();

double GMT(); 
double gmta(); 

int leapyear(); 
double xjdnow(); 

/* ---------------------------------------------------------------- 
 * former jpl.h, some structures for reading an ascii ephemeris file 
 * 89/01/20 ff.
 * a. porter
 * ----------------------------------------------------------------
 */

#define SUNCENTERED 0
#define BARYCENTERED 1 
#define EARTHCENTERED 2
#define SUNINDEX 10	/* body-index of sun in jpl's ephemeris */
#define EARTHINDEX 17	/* body-index of the earth;
			   the value is to be out of range used by JPL */
#define EARTHMOONBARYCENTER 2 /* body-index of e-m barycenter */ 
#define MOONINDEX 9	/* body-index of moon in jpl eph. (u can't change this) */ 

/* these are used by planets.c; they are not arbitrary,
 * but are defined by indexing into the JPL ephemeris data records:
 */ 
#define MERCURY 0
#define VENUS 1
#define EARTH 2
#define MARS 3
#define JUPITER 4
#define SATURN 5
#define URANUS 6
#define NEPTUNE 7
#define PLUTO 8
#define MOON 9
#define SUN 10
#define NUTATIONS 11
#define LIBRATIONS 12 

#ifdef unused 
/* this is for planets.c, unfinished code: */ 
#define TIMES 15
#define DPSI 13
#define DEPS 14
#endif unused 

#define AUDAY 0
#define MKS 1 

#define JPLFormat  2 
#define ODIVFormat 3

#define TellTableSize 512 /* in rwod.c etc., size of tables of results of ftell */ 

typedef struct groupheader
{
    int 	size; 
    int		type;
    int 	key;
}	GroupHeader; 


typedef struct group4data
{
    double earliestDate;
    double latestDate;
    double recordLength;     /* duration of one data record, units == days */ 
    double recordInterval;   /* interval between data records (days)       */ 
    int    numberOfBodies;
    double versionNumber;
}	Group4Data;


/* max number of lines of ascii header info in groups 1, 2 */ 
#define OneSize 10
#define TwoSize 10
      /* longer than a line length: */
#define LONGlineLENGTH 120     


/* 199 is right for de-200; too big for de-245, 
 * but the o-div header for de-245 has void entries
 * that end the loop in rwod.c where groups 5-6 get read:
 */ 
#define GROUP_SIX_SIZE 199

/* these are typically array sizes, used in both taperead.c and tapestrc.c */ 
/* used in group 5 and group 6, length of array of names, and of values */ 
#define NAMELENGTH 200


/* ---------------------------------------------------------------- */
/* size of a name in the array of names in group 5 */ 
#define NAMESIZE 7		/* 6 chars plus a null */

/* number of triples of numbers in group 7 
 * (it may grow beyond 12, especially if lunar librations
 * are added for ephemerides beyond de-245 
 * librations added with de-400, 1995/01/23; sevenSize set to 13 then 
 *
 * the defined constant sevenSize is used in older code;
 * use only SEVENSIZE 
 */ 
#define sevenSize 13
#define SEVENSIZE 13

/* this tells the structure of the chebyshev poly-coeff block:
 * how many coefs per body, how many sub-periods per period.
 * it was specified in the 7th group of numbers 
 * in ephemeris formats that are older than about 1988
 */ 
typedef struct tapestructure 
{
     int      first[sevenSize]; 
     int    ncoeffs[sevenSize];
     int nintervals[sevenSize];
} TapeStructure; 

/* max number of sub-intervals for a body in data-record */ 
#define maxIntervals 12	 

/* DATASIZE gives size of one record's chebyshev polynomial coefficient block --
 * this changes with each ephemeris.  for de-245, it is 898; less than 1024
 * if you modify code or upgrade to a later ephemeris, be aware of this ... 
 * (for de-400, 1018 of the 1024 are used; 1024 is barely enough) 
 */
#define DATASIZE 1024


/* this was an unfortunate choice of name for 
 * what is a data-record taken together with all the header and structure info,
 * but it is now (1994) long sedimented.
 * "heap" is a technical term in computer science;
 * here, it just means a hill of data of quite various kinds,
 * and "record" is in some places used to refer
 * to the block of chebyshev polynomial coefficients for one segment 
 * of time in the ephemeris; usually a 32-day period. 
 */

typedef struct tapeheap
{
    char catfile[LONGlineLENGTH+1]; /* name of catalog file via which this data was obtained */ 
    char groupOne[OneSize][LONGlineLENGTH];
    char groupTwo[TwoSize][LONGlineLENGTH];
    Group4Data groupFour; 
    char groupFive[NAMELENGTH][7];
    double groupSix[NAMELENGTH];
    TapeStructure groupSeven;
    double jdStart;		/* start date for the data record that follows */ 
    double jdEnd;		/*   end date for the data record that follows */ 
    int index[sevenSize][maxIntervals][3];
    int recordCount; /* number of records in the tape from which this record came */ 
    double data[DATASIZE];	
    /* index [body] [subinterval] [component]: 
     * startOfArray = &(heap->data[ heap->index[body][subindex][component]  ]  ); 
     */
    /* int    index[sevenSize][maxIntervals][3]; */ 
    int size56;			/* size of groups 5 and 6 */ 
    int DEnumber;		/* ephemeris number */ 
} TapeHeap; 


/* ------------------------- subroutines ------------------------------ */ 


TapeHeap *getHeaderHeap(); 

/* this next should be considered obsolete,
 * though some code not in this directory uses it;
 * it is for an old JPL ascii ephemeris format
 */ 
TapeHeap *GetHeapFromJPL(); 

TapeHeap *GetHeapFromOdiv(
			  char *catalog, 
			  char *filename,
			  FILE *fi,
			  double jd
			  ); 

TapeHeap *GetHeapByFtell(
			  char *catfile, 
			  char *filename,
			  FILE *fi,
			  double jd
			  ); 

/* int header_decoder( GroupHeader *header, char *line ); */
int header_decoder();

/* int properField( char *s); */
int properField();

/* int blank_line( char *s ); */
int blank_line(); 

int header_detector();
int trailer_detector( char *line );
int comment();

char *ephemline();	/* reads a line from ephemeris, ignores comments */ 

int group4( FILE *fi, Group4Data *data ); 
int group7( FILE *fi, TapeStructure *seven ); 
int getRecordLength( TapeStructure *seven ); 

void planetsDemo(); 

FILE *getTape( 
	      double jd, 
	      char *catalogFile, 
	      double *tapeStart, 
	      double *tapeEnd 
	      ); 

int jplBody( 
	    double jd, 
	    char *catalogFile, 
	    int body, int center, 
	    int units, 
	    Coord3d *position, 
	    Coord3d *velocity 
	    );

int 
jplEphemeris( 
	     double jd,
	     TapeHeap *heap,
	     int body,
	     Coord3d *position,
	     Coord3d *velocity
	     );

int 
jplPosVel( 
	  double jd,
	  TapeHeap *heap,
	  int body,
	  int units,
	  Coord3d *position,
	  Coord3d *velocity
	  );


int 
tapeToNextRecord( 
		 FILE	*fi,	
		 int 	 size,
		 double	*jd0,
		 double *jd1 
		 );

int
dataRecord( 
	   char	*line,	
	   int	*n0,	
	   double	*e1,	
	   double 	*e2,
	   double 	*e3	
	   );

TapeHeap *
getEmptyHeap( 
	     FILE *fi 
	     ); 

int 
dumpEmptyHeap(
	      FILE *fo, 
	      TapeHeap *heap
	      );

int 
fileToEmptyHeap(
		char *filename, 
		TapeHeap *heap
		);

int
dumpRecord( 
     FILE	*fo,
     TapeHeap	*heap
	   );

int
orderHeap( TapeHeap *heap ); 

int 
jplCenter( 
     double 	 jd,		
     TapeHeap 	*heap,	
     int 	 body,		
     int 	 center,	
     int 	 units,		
     Coord3d 	*position,	
     Coord3d 	*velocity  
	  );

int  
positionOdivFile( 
     FILE *fi,
     double jd,
     double *jdStart,
     double *jdEnd  
		 );

/* some of the routines in findheap.c */ 
FILE *logfile(); 
int 
jplFormat();

int 
odivFormat();

int 
binaryFormat();

int needHeap(); 


TapeHeap *catHeadToHeap(); 

TapeHeap *
catToHeap( 
	  double jd, 
	  char *catalogFile 
	    ); 

char * getHeaderName(); 

char *getEphemerisCatalog(); 
int getTellInfo( char *, double starts[], double ends[], long int tells[] );

FILE *getDataFile( 
	      double jd, 
	      char *catalogFile, 
	      double *tapeStart, 
	      double *tapeEnd, 
	      char *datafilename 
	      ); 

 
/* ---------------------------------------------------------------- */
/* abbreviations, referring to the literature consulted:
 *
 * BMW = Roger R. Bate, Donald D. Mueller, Jerry E. White, 
 *	Fundamentals of Astrodynamics, NY, Dover, 1971, full of typos 
 * Allen = C. W. Allen, Astrophysical Quantities, Univ. of London, 
 *	the Athlone Press, 1973
 * LLM = L. D. Landau & E. M. Lifshitz, Mechanics, 4th ed., Pergamon, 1976
 * Smart = W. M. Smart, Text-Book on Spherical Astronomy, Cambridge U. P., 1971
 * Green = Spherical Astronomy, Camb. U. P., 1985
 * Moulton = Forrest Ray Moulton, An Introduction to Celestial Mechanics,
 *	2nd ed., NY, Dover, 1970 
 * BAG  = Richard H. Battin, Astronautical Guidance, NY, McGraw Hill, 1964
 * BMMA = Richard H. Battin, An Intro to the Maths and Methods of
 * 	Astrodynamics, AIAA, 1987
 * GBG = G. Bomford, Geodesy, Oxford, Clarendon Press, 1971
 * Thomas_1953 = G. B. Thomas, Calculus, Reading MA, Addison-Wesley, 1953
 * AstAlmanac88  = The Astronomical Almanac, 1988, USGPO & HMSO
 * NautAlmanac88 = The Nautical Almanac, 1988, USGPO & HMSO
 * CB  = Clemence and Brouwer, Methods of Celestial Mechanics, NY,
 * 	Academic Pr, 1961
 * DOA TN 88-02 = H. B. Wackernagel, TechNote 88-02, 
 *               Proposed Astrodynamic Standards, 
 *		USAF Space Command, Peterson AFB, 88/02/29 
 * Zombeck = Martin V. Zombeck, Handbook of Space Astronomy and Astrophysics,
 *	Camb. UP, 1982 
 * ESAA or ESAA-1992 = Explanatory Supplement to the Astronomical Almanac, 1992
 * ESAA-1961 = same, 1961 edition (quite different) 
 * EMP = Ephemeris of Minor Planets, St. Petersburg, 1992, Inst. Theor. Astronomy
 * Herbert Goldstein, Classical Mechanics, Addison-Wesley, 1950
 * C. A. Murray, Vectorial Astrometry, Adam Hilger Ltd., 1983
 * Press, Vetterling, Teukolsky, Flannery, Numerical Recipies in C, 
 *							  1st and 2nd editions
 * Planetary and Lunar Coordinates for the years 1984-2000, HMSO and USGPO, 1983 
 * Pedro Ramon Escobal, Methods of Orbit Determination, 1965, rev. 1976  
 * Oliver Montenbruck, Practical Ephemeris Calculations, Springer, 1989
 * papers describing the JPL ephemerides: 

        Newhall,X X, Standish,E.M. and Williams,J.G.: 1983, "DE102: a numerically
        integrated ephemeris of the Moon and planets spanning forty-four
        centuries", Astronomy & Astrophysics, vol. 125, pp. 150-167.

        Standish,E.M.: 1982, "Orientation of the JPL Ephemerides, DE200/LE200, to
        the Dynamical Equinox of J2000", Astronomy & Astrophysics, vol. 114, pp.
        297-302.

                : 1985, "Planetary and Lunar Ephemerides, DE125/LE125", JPL IOM
                314.6-591.

                : 1987, "Ephemerides, DE130/LE130 & DE202/LE202", JPL IOM 314.6-891.

                : 1990, "The Observational Basis for JPL's DE200, the planetary
                ephemeris of the Astronomical Almanac", Astronomy & Astrophysics,
                vol. 233, pp. 252-271.

                : 1991, "The JPL Planetary and Lunar Ephemerides DE234/LE234", JPL
                IOM 314.6-1348.

 * papers describing the US Naval Observatory Vectorial Astrometry Software:
 *      George H. Kaplan, "NOVAS", {Bull Amer Astron Soc} 22 (1990) 930 
 *      George H. Kaplan, J. A. Hughes, P. K. Seidelmann, C. A. Smith, B. A. Yallop,
 *              "Mean and Apparent Place Computations in the New IAU System.  III.
 *              Apparent, Topocentric, and Astrometric Places of Planets and Stars,"
 *              {Astron J} 97 (1989) 1197
 * 
 */

/* end of hnav.h */


