/* ----------------------------------------------------------------
 * matrix.h
 * provides vector and matrix operations
 * SOME OF THEM DIFFER from geometry.h and geometry.c
 * (geometry.c contained a partial overlap of this code, 
 *       and is not included here;
 *       please pardon the comments that refer to other code ... ) 
 *
 * in particular, for matrix * vector, we pre-multiply !!
 * compare listing of matVMult() here with GeoTransCoord() in geometry.c !!!!
 * 
 * in particular, 
 *	vectors  		type Coord3d,
 * 	euler angles 		type EulerRot
 * 	polar coords 		type PCoord
 * But Matrices Are Not Type Transform3d !!!! 
 * 	matrices		type matrix3d
 * matrix3d's are pre-multiplied, Transform3d's are post-multiplied !!!!
 *
 * we interpret EulerRot's differently here !!
 * 	for graphics, an EulerRot is from rotated frame to world frame.
 *	in the convention of Euler angles in orbital elements, 
 *		they are from world to rotated frame. 
 *
 * author(s) originally, I think Walter Scott;
 *	others have modified some of this code
 * ----------------------------------------------------------------
 */


/* ---------------------------------------------------------------- */
/* brought from geometry.h */ 

/*
 * Rotation represented as Euler angles (in radians).
 * These correspond to three rotations applied in the order in which they
 * appear in the structure.
 */
typedef struct
{
    double	 er_1;	/* About z-axis */
    double	 er_2;	/* About transformed x-axis */
    double	 er_3;	/* About twice transformed z-axis */
} EulerRot;

/*
 * Rotations can also be expressed as a quaternion (q1, q2 q3 q4) where
 * q1, q2, and q3 define an axis and q4 is the amount to rotate around
 * that axis.
 */
typedef struct
{
    double q1, q2, q3; 	/* The axis */
    double q4;		/* The angle to rotate about the axis */
} Quaternion;


/* --------------------- 3-d cartesian geometry ----------------------- */

/*
 * All cartesian coordinate systems we use are right-handed, as below.
 *
 *		z
 *		|
 *		|
 *		|
 *		+-------y
 *	       /
 *	      /
 *	     /
 *	    x
 */

/* this is used probably more than any other single defined type: */ 

typedef struct coord3d { double x, y, z; } Coord3d;


/* --------------------- Spherical polar geometry --------------------- */

/*
 * Point in spherical polar coordinates.
 * Angles are in radians.
 *
 *		z
 *		|
 *		|
 *		|
 *		+------- y
 *	       /
 *	      /
 *	     /
 *	    x
 *
 * Latitude along the +z axis is PI/2, in the equatorial plane is 0,
 * and along the -z axis is -PI/2.
 *
 * Longitude along the +x axis is 0, increasing to PI/2 along the
 * +y axis, PI along the -x axis, then 3*PI/2 on -y, and back to
 * 0 as we return to +x.
 */


typedef struct pcoord
{
    double	 pc_r;		/* Radius (meters) */
    double	 pc_long;	/*     0 - 2*PI in x-y plane */
    double	 pc_lat;	/* -PI/2 - PI/2 (latitude) above x-y plane*/
} PCoord;


/* -------------------- Exported procedures --------------------------- */

extern double GeoVectorLength();
extern double GeoDistance();
extern double GeoDotProduct();

void GeoScalarMultVector(); 
void GeoZeroVector(); 
void GeoSubtractVector(); 
void GeoAddVector(); 
void GeoCrossProduct();
double GeoDotProduct(); 
bool GeoUnitVector(); 

/* ---------------------------------------------------------------- */



typedef double matrix3d[3][3];


FILE *getfile(  ); 

 double matAngleofVectors(); 

 double reduce();
 void matUnitMatrix();
 void matScalarMultMat();

 double normalize();
 double dnormalize();
 int matInvert();

 double matSize();
 double matDeterminant();
 void matcopy();
 void matDiff();
 void matMult();
 void matDump();
 void matVMult(); 
 void matERot();	/* matEMat and matERot are called differently. */
 void matEMat();	/* they do the same thing. */
 void matMatE();
 void matTranspose();
 void matMatToTransform();
 void matTransformToMat(); 
 void matAccumulateVector();
 void matPolarUnitVectors();
 void matRectToPolar(); 
 void ZXtoMatrix(); 

 void matCopy();

void ZXtoMatrix(); 
 
typedef struct factors 
  {
      double rad;
      double phi;
      double lam;
  } Factors;
