/*
 * ms.h --
 *
 * general .h file 
 * Contains misc global typedefs, etc.
 * If you #include <sys/types.h>, do so BEFORE #including this file.
 *
 * under other filenames, Walter Scott wrote most of this originally
 * 	other O Division people have modified it some 
 * many of the definitions here are not used in this code,
 * but were widely used in the code from which this is excerpted.
 */



/*
 * Miscellaneous constants.
 * defined here since this file gets included virtually everywhere.
 */
#define	LINESIZE	1024	/* Length of longest input line */

/* ------------------ Unsigned type abbreviations --------------------- */

/* #ifndef _TYPES_ */  /* have to change this as Mips RiscOs uses a 
                        *different symbol in sys/types.h.  :-(  */
#if !defined(_TYPES_) && !defined(_SYS_TYPES_)
#define	_TYPES_
#define _SYS_TYPES_
typedef char *		caddr_t;
typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef unsigned int	u_int;
typedef unsigned long	u_long;
#endif	_TYPES_
#ifndef NBBY
#define	NBBY		8	/* number of bits in a byte */
#endif

/* --------------------- Universal pointer type ----------------------- */

typedef char *ClientData;

/* --------------------------- Booleans ------------------------------- */

#ifndef	bool
#	define	bool	int
#endif	bool
#ifndef	TRUE
#	define	TRUE	1
#	define	FALSE	0
#endif	TRUE

/* ------------------------- Fixpoint type ---------------------------- */

/*
 * The FixPoint type is used whenever we want to deal with fractions
 * of integers.  Addition and subtraction of FixPoints are normal,
 * as are multiplication or division of a FixPoint and an integer.
 * Multiplication and division of two FixPoint numbers, however,
 * require use of the special macros below.  The parameter 'fbits'
 * in these macros is the number of bits to the right of the binary
 * point.
 */
typedef long FixPoint;

/* Operations on two FixPoint numbers */
#define	FIX_MULT(a, b, fbits)	( ((a) * (b)) >> (fbits) )
#define	FIX_DIV(a, b, fbits)	( ((a) << (fbits)) / (b) )

/* --------------------------- Infinities ------------------------------ */

/* Maximum representable positive integer */
#ifndef MAXINT
#define MAXINT (((unsigned long) ~0) >> 1)
#endif

/* ----------------------- Simple functions --------------------------- */

#define MAX(a,b)	(((a) < (b)) ? (b) : (a))
#define MIN(a,b)	(((a) > (b)) ? (b) : (a))
#define	ABS(x)		(((x) >= 0)  ? (x) : -(x))
#define	ABSDIFF(x,y)	(((x) < (y)) ? (y) - (x) : (x) - (y))
#define ODD(i)		(i&1)
#define EVEN(i)		(!(i&1))

/* Round anything (e.g. a double) to nearest integer */
#define ROUND(x) ((int)((x)+.5))

/* ------------ Function headers of globally used functions ----------- */

#ifdef mips
extern char *strcpy(char *, char *);
extern char *strncpy(char *, char *, int);
extern char *index(char *, int);
extern char *rindex(char *, int);
extern char *strcat(char *, char *);
extern char *strncat(char *, char *, int);
#else
extern char *strcpy(), *strncpy(), *index(), *rindex();
extern char *strcat(), *strncat();
#endif

/* --------------------- Debugging and assertions --------------------- */

#ifdef	PARANOID
#define	ASSERT(p, where) \
    ((!(p)) \
	? (sprintf(AbortMessage, "%s botched: %s\n",  \
	    where, "p"), \
	fputs(AbortMessage, stderr), \
	abort(), \
	TRUE) \
	: FALSE)
extern char AbortMessage[];
#else
#define	ASSERT(p, where)	(FALSE)
#endif	PARANOID

/*
 * There could be a Void type, which is like void except that we
 * can declare pointers to functions that return it.
 * (Not implemented for the present.)
 */


