/* 
 * catalog.c will read its input arguments, 
 * assumed to be o-div ("O division") format ascii 
 * ephemeris files, and from the info at the start
 * and end of records print out one line that tells 
 * the start and end date for that file;
 * if you pipe this output to a saved file,
 * that file can be used as a catalog file,
 * that is, a file in which odiv planetary code 
 * can look up where to find the data it wants.
 *
 * andrew p. porter, porter@s1.gov, 1994/summer
 *
 */ 



#include <stdio.h>
#include <stdlib.h>

char *fvfJulianToDate(); 

/* see the on-line man pages for the value of SEEK_END: */ 
#define SEEK_END 2


main( argc, argv )
     int argc;
     char *argv[];
{  
    FILE *fi; 		/* for input file */
    char *line;		/* ptr to line of input */ 
    char buf[125]; 	/* to hold line of input */ 
    int count;		/* sscanf returnvalue */ 
    int fileNumber; 
    int newfile;

    double jdX, jdY; 
    double jdStart, jdEnd; 
    char startDate[32];
    char endDate[32]; 


    for( fileNumber = 1; fileNumber < argc; ++fileNumber )
    {

	fi = fopen( argv[fileNumber], "r" );
	if (fi == NULL)
	{
	    printf(" couldn't open %s \n", argv[fileNumber] );
	    exit(0);
	}

	newfile = 1; 
	while( 1 )
	{
	    line = fgets( buf, 120, fi );
	    if ( line == NULL)
	    {
		break; 
	    }
	    if ( newfile )
	    {
		count = sscanf( line, "record %lf", &jdStart  );
		if( count == 1)
		{
		    newfile = 0; 
		    fseek( fi, -200, SEEK_END ); 
		}
	    }
	    count = sscanf( line, "end of record %lf to %lf",
			   &jdX, &jdY );
	    if (count == 2)
	    {
		jdEnd = jdY; 
	    }
	}
	fclose( fi ); 
	
	strcpy( startDate, fvfJulianToDate( jdStart) );
	strcpy( endDate,   fvfJulianToDate( jdEnd  ) ); 
	
	/* write specs */ 
	printf("start: %12.2f end: %12.2f %s ( %s to %s )\n", 
	       jdStart, jdEnd, argv[fileNumber], startDate, endDate ); 

    }

}





/* ----------------------------------------------------------------
 * fvfJulianToDate is Fliegel and Van Flandern's algorithm
 * 
 * inputs
 *	julian date
 * outputs
 *	ptr to gregorian calendar date string
 * side effects
 *	sets calendar date integers pointed to on input
 * method
 *	convert JD to unix-time, and unix-time to Gregorian calendar date
 * cautions
 *	use the answer before you loose it . . . it is in static storage here
 * Source 
 *	Henry F. Fliegel, Thomas C. Van Flandern, "Machine Algorithm 
 *	for Processing Calendar Dates," [Commmunications?] of the ACM, 11#10 (1968/10) ?? 
 *	modulo changes in NOTES below, this is code from ~/wnav/sources/calendar.c, 
 *                  94/08/15
 * BUGS
 *	sets hour, min, sec to zero 
 * NOTES
 *	output string has been truncated to date, w/o time of day 
 * ----------------------------------------------------------------
 */

char * 
fvfJulianToDate( jd )
     double  jd;	/* floating Julian date (1970.0 (0h UT Jan 1 1970) is JD 244 0587.5 */
{
    double jdnoon;	/* jd at noon on the day in question */ 
    int L,N;
    int year;
    int month; 	/* month = 1-12 */ 
    int day; 	/* a presume 1 to 28-31 */ 
    static char nice[100];	/* to hold the answer */
    double fraction; 	/* fraction of day */ 
    int hour, minute, second;		/* time of day in integers */ 
    double fhour, fminute, fsecond;	/* time of day in floats */ 

    jdnoon = (double) (int) ( jd + 0.5 ); 
    fraction = jd - (jdnoon - 0.5 );

    /* Fliegel and Van Flandern's algorithm: */ 
    L = jdnoon + 68569;
    N = 4 * L / 146097; 
    L = L - (146097*N + 3) / 4; 

    year = 4000 * (L+1) / 1461001; 
    L = L - 1461 * year / 4  +  31; 
    month = 80 * L / 2447; 
    day = L - 2447 * month / 80;
    L = month / 11;
    month = month + 2 - 12 * L;
    year = 100 * ( N - 49)  +  year + L;
    /* end of F & vF's algorithm */ 

    fhour = fraction * 24.;
    hour = (int) fhour;
    fminute = (fhour - hour) * 60.;
    minute = (int) fminute; 
    fsecond = (fminute - minute) * 60.; 
    second = (int) fsecond; 

    /* now format the time in struct t to string nice: */
    (void) sprintf( nice, "%d/%2d/%2d", year, 
		  month, day ); 

    return nice;	/* for now . . . better later */

}



