/* output routines to print angles in babylonian (i. e., sexagesimal) units */

#define LANGUAGE_C
#include <stdio.h>
#include <math.h>

#include "../include/ms.h"
#include "../include/matrix.h"
#include "../include/hnav.h"

extern char *malloc();
extern double normalize();

/* ----------------------------------------------------------------
 * printDegMin
 *	
 * input
 *	angle in radians 
 * outputs
 *	none
 * side effects
 * 	prints angle in degrees, minutes, and decimal fractions of a minute
 * ----------------------------------------------------------------
 */

void
printDegMin(x)
     double x;	/* angle in radians */
{
    double theta;	/* whole angle in radians */
    int degrees;	/* integer part of angle in degrees */
    double minutes;	/* fractional part of angle, in minutes */

    theta = x * TODEGREES;
    degrees = theta;
    minutes = theta - degrees;
    minutes *= 60.;
    printf("% 4dd % 4.2fm ", degrees, minutes);

}


/* ----------------------------------------------------------------
 * printHoursMS
 * input
 * 	angle in radians
 * outputs
 *	none
 * side effects
 *	prints angle in hours minutes seconds
 * ----------------------------------------------------------------
 */

void 
printHoursMS(angle)
     double  angle;	/* angle in radians */
{ radToHMS( angle ); }

void 
radToHMS( angle )
     double angle;	/* angle in radians */
{
    double theta;	/* whole angle in radians */
    int degrees;	/* integer part of angle in degrees */
    double minutes;	/* fractional part of angle, in minutes */
    int int_minutes;	/* integer part of angle in minutes */
    double seconds;	/* whole number of seconds */

    theta = angle * TODEGREES / 15.;	/* convert to angular hours */
    degrees = theta;
    minutes = theta - degrees;
    minutes *= 60.;
    int_minutes = minutes;
    seconds = minutes - int_minutes;
    seconds *= 60.;
    printf("% 3dh % 3dm % 7.3fs", degrees, int_minutes, seconds);

}



/* ----------------------------------------------------------------
 * printDegsMS  . . . prints an angle in babylonian units
 * input
 * 	angle in radians
 * outputs
 *	none
 * side effects
 *	prints angle in degrees minutes seconds
 * method
 *	calls printDMS 
 * ----------------------------------------------------------------
 */

void 
printDegsMS(angle)
     double angle;	/* angle in radians */
{
    double theta;	/* whole angle in radians */
    int degrees;	/* integer part of angle in degrees */
    double minutes;	/* fractional part of angle, in minutes */
    int int_minutes;	/* integer part of angle in minutes */
    double seconds;	/* whole number of seconds */

    theta = angle * TODEGREES;
    degrees = theta;
    minutes = theta - degrees;
    minutes *= 60.;
    int_minutes = minutes;
    seconds = minutes - int_minutes;
    seconds *= 60.;
    printf("% 4dd % 3dm % 6.2fs", degrees, int_minutes, seconds);

}


/* ----------------------------------------------------------------
 * hoursms() and degsms() return character strings
 * 	which are formated to hours, minutes, seconds 
 *	and degrees, minutes, seconds conversion from 
 *	these subroutines' arguments, which are in radians
 * ----------------------------------------------------------------
 */ 

char *
hourms( angle )
     double angle; 
{
    static char even[40];
    static char odd[40]; 
    static int evenodd=0;

    double theta;	/* whole angle in radians */
    int degrees;	/* integer part of angle in degrees */
    double minutes;	/* fractional part of angle, in minutes */
    int int_minutes;	/* integer part of angle in minutes */
    double seconds;	/* whole number of seconds */

    theta = (angle * TODEGREES) / 15.;		/* to hours */ 
    theta = normalize( theta, 0., 24. ); 	/* 24-hour notation */ 
    degrees = theta;
    minutes = theta - degrees;
    minutes *= 60.;
    int_minutes = minutes;
    seconds = minutes - int_minutes;
    seconds *= 60.;

    if (evenodd == 0)
    {
	sprintf( even, "% 4dh % 3dm % 6.2fs", degrees, int_minutes, seconds);
	evenodd = 1;
	return even;
    }
    if (evenodd == 1)
    {
	sprintf(  odd, "% 4dh % 3dm % 6.2fs", degrees, int_minutes, seconds);
	evenodd = 0;
	return odd;
    }

    return NULL; 
}


char *
degms( angle )
     double angle; 
{
    static char even[40];
    static char odd[40]; 
    static int evenodd=0;

    double theta;	/* whole angle in radians */
    int degrees;	/* integer part of angle in degrees */
    double minutes;	/* fractional part of angle, in minutes */
    int int_minutes;	/* integer part of angle in minutes */
    double seconds;	/* whole number of seconds */

    theta = angle * TODEGREES;
    degrees = theta;
    minutes = theta - degrees;
    minutes *= 60.;
    int_minutes = minutes;
    seconds = minutes - int_minutes;
    seconds *= 60.;

    if (evenodd == 0)
    {
	sprintf( even, "% 4dd % 3d' % 6.2fs\"", degrees, int_minutes, seconds);
	evenodd = 1;
	return even;
    }
    if (evenodd == 1)
    {
	sprintf(  odd, "% 4dd % 3d' % 6.2fs\"", degrees, int_minutes, seconds);
	evenodd = 0;
	return odd;
    }

    return NULL; 

}
