

/* ----------------------------------------------------------------
 * chebev.c, chebyshev polynomial series evaluation 
 * 91/11/05 ff., from xintrp.f, extracted from emsap.f,
 *	jpl's fortran for reading their tape ephemeris 
 * ----------------------------------------------------------------
 */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>


#include "../include/nrutil.h"

#include "../include/ms.h" 
#include "../include/matrix.h"
#include "../include/hnav.h"


/* ----------------------------------------------------------------
 * chebeval evaluates three chebyshev series in tandem
 *	(it's for vectors) 
 * inputs 
 *	argument, t, between 0 and 1
 * 	chebyshev coefficients, arrays
 *	size of cheb. coeff. arrays
 *	ptr to quantity  to be evaluated 
 *	ptr to its derivative, also to be evaluated 
 * outputs
 *	1 for success, 0 for failure 
 * side effects 
 *	sets the vector of output values
 * ----------------------------------------------------------------
 */

int
chebeval( t, cx, ncoeffs, f, fdot )
     double	t; 	/* the argument, e [0,1]  */ 
     double	cx[];	/* coefficients for the chebyshev series */
     int	ncoeffs; /* number of coefficients in the 3 series */ 			  
     double	*f;	/* the function to be evaluated */ 
     double	*fdot;	/* its derivative: you MUST scale for units YOURSELF */ 
{
    static double t_old=-1.;	/* t of last time we were called */ 
    static double tb;		/* t, "biased"  to the interval [-1,1] */ 
    static double two_tb;		/* 2. times tb */ 
    static double poly[20];	/* for the chebyshev polynomials of the first kind  */ 
    static double polyvel[20];	/* polynomials for velocities  */ 
    int		i;		/* loop control */ 
    double	sum;		/* to accumulate value of f in */ 

    if ( t < 0.0 || t > 1.0 ) 
      {
	  printf(" called chebeval with t = %e, out of range \n", t ); 
	  return 0; 	/* fail, argument out of range */ 
      }

    /* generate polynomial values, but only if argument is different from that of last call: */ 
    if ( t != t_old ) 
    {
	tb	= 2.*t - 1.;	/* this is the transposition to "bias" t 
				   so that the argument to chebyshev polynomials 
				   is in correct range of [-1,1]
				   */
	two_tb	= 2. * tb; 	/* used in recursion relations */ 

	poly[0] = 1.;
	poly[1] = tb;
	polyvel[0] = 0.;
	polyvel[1] = 1.;

	for (i=2; i<ncoeffs; ++i)
	{
	    poly[i] = two_tb * poly[i-1]  -  poly[i-2]; 
	    /* the derivative of which is: */ 
	    polyvel[i] = two_tb * polyvel[i-1] + 2.*poly[i-1] - polyvel[i-2];
	}
    }

    /* sum the series; order is JPL's */ 
    sum = 0;
    for( i=ncoeffs-1; i>=0; --i)
    {
	sum += poly[i] * cx[i]; 
    }

    *f = sum;

    /* do this later . . . */ 
    sum = 0;
    for( i=ncoeffs-1; i>=0; --i)
    {
	sum += polyvel[i] * cx[i]; 
    }
    *fdot = sum; 


    return 1; 

}
