
/* ----------------------------------------------------------------
 * jplgen.c
 * this dates from the old days (1987) of reading from 
 * the de-200 ephemeris in its native UNIVAC ascii format
 * I believe some of it is still used for other things, though
 * ----------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <string.h>

/* link with nrutil.o, in same directory */
#include "../include/nrutil.h"

#include "../include/ms.h" 
#include "../include/matrix.h"
#include "../include/hnav.h" 

extern double normalize();



/* ----------------------------------------------------------------
 * ephemline gets a line from the ephemeris file, ignoring comments
 * inputs 
 *	FILE descriptor
 * outputs 
 *	ptr to line for success, ptr to NULL for failure (e. g., EOF)
 * side effects
 * 	none
 * cautions
 *	use the line before you lose it: it is in a buffer here
 * ----------------------------------------------------------------
 */

/* this next is "global" storage, but may be used ONLY ONLY ONLY ONLY by these two routines: */ 
static char ephem_buffer[137];	/* where to save the lines gotten */ 
static int  ungetter=0;		/* whether to re-give the last line gotten */ 

char *
ephemline( fi )
     FILE *fi;	/* the stream to read from */ 
{
    static char buf[120]; 
    char *line; 
  
    if (ungetter)
    {
	ungetter = 0; 
	return ephem_buffer; 
    }

    while (( line = fgets( ephem_buffer, 120, fi )) != NULL)
    {
	if ( ! comment( line ) ) 
	{
	    strcpy( buf, line ); 
	    return buf; 
	}
    }

    return (char *) NULL; 
}

void
ungetEphemLine( line )
     char *line;	/* the line to be given on next call to ephemline()  */ 
{
    strncpy( ephem_buffer, line, 135 ); 
    ephem_buffer[134] = '\0'; 
    ungetter = 1; 
}





/* ----------------------------------------------------------------
 * comment detects comment lines: lines beginning with ';' 
 *            ... and blank lines 
 * inputs
 *	ptr to line
 * outputs
 *	1 (yes) or 0 (no)
 * side effects
 *	none
 * ----------------------------------------------------------------
 */

int comment( line )
     char *line; 
{
    static incomment=0;		/* whether we are in multiple-line comments or not */ 

    if (*line == ';') return 1;
    if ( blankLine(line) ) return 1; 

    if (*line == '[') 	
    {
	incomment = 1;
	return 1;
    }
    if (*line == ']')	
    {
	incomment = 0;
	return 1;
    }


    if (incomment == 0) return 0;
    if (incomment > 0) return 1; 

    return 0; 

}


/* ----------------------------------------------------------------
 * blankLine detects a blank line: no printable characters
 * inputs
 * 	a string, terminated by '\0' 
 * ouputs
 *	1 for blank, 0 for not-blank
 * side effects
 *	none
 * ----------------------------------------------------------------
 */

int
blankLine( line )
     char *line;
{
    char *s; 

    for( s=line; *s; ++s )
    {
	if ( !isspace( *s )  )
	{
	    return 0; 
	}
    }
    return 1;

}





/* ----------------------------------------------------------------
 * getRecordLength calculates ephemeris data record length,
 *	ephemeris in JPL format (not proprietary format)
 *	from the array supplied in group 7
 * inputs
 * 	array of parameters
 * outputs
 *	resulting size, including the start and stop dates 
 * side effects
 * 	none
 * quandaries . . . 
 *	not all bodies are the same: 
 *	the planets etc. have 3 coordinates (x,y,z), 
 *	but nutations are two: longitude and obliquity
 *	i'm not sure whot is really here 
 * NOTE
 *	this includes the 2 dates at start of record; 
 *	the actual data-length is 2 less 
 * ----------------------------------------------------------------
 */ 

int 
getRecordLength( parameters )
     TapeStructure 	*parameters;	/* this is gotten from group7() */
{
    int size;	/* the number we are trying to compute */ 
    int k;	/* loop control */ 
    int components; /* number of components, i. e., num. of coords */ 

    size = 2;	/* allow two places for jd-start and jd-end */

    /* you would think we would go to group 4 for loop upper limit
     * (the number of bodies) here,
     * since it may be less than SEVENSIZE, 
     * but group 4 is not here as an argument to this routine.  
     * We assume unused members of group Seven are zeros.
     */ 
    for (k=0; k<SEVENSIZE;  ++k)
    {
      components = 3;
      if (k == NUTATIONS)
	components = 2; 
      size +=   parameters->ncoeffs[k] 
 	      * parameters->nintervals[k] 
	      * components; 
    }


    return size; 

}


/* ----------------------------------------------------------------
 * orderHeap sets in order some of the members of a TapeHeap
 * inputs
 *	the TapeHeap to be ordered 
 * outputs 
 * 	1 for success 
 *		( and 0 for failure, if we ever try to detect inconsistency)
 * side effects
 * 	sets heap->index[][][], zeros heap->data
 * ----------------------------------------------------------------
 */ 

int 
orderHeap( heap )
     TapeHeap *heap;		/* the heap to be ordered */ 
{
    int k, kk, j;		/* loop control */ 	
    int components;		/* number of components (2 or 3) in a data set */ 
    int first;
    int size;
    int next;

    /* now set the index array in the heap: */ 
    /* first zero them all */
    /* this loop should go to SEVENSIZE, 
     * the size of the array,
     * rather than to numberOfBodies,
     * the part of the array that is used:  
     */ 
    for(k=0; k<SEVENSIZE; ++k )	
    {	
	if (k != NUTATIONS) 		/* 0-10 == "bodies" 1-11, real bodies */ 
	  components = 3;	/* xyz; for planets */ 
	else 			/* 11 == "body" 12, nutations; not a real body */
	  components = 2; 	/* dpsi, deps; for nutations */ 
	for ( kk=1; kk<=heap->groupSeven.nintervals[k]; ++kk) /* sub-intervals */ 
	  for ( j=0; j<components; ++j)			/* loop on components */
	    heap->index[k][kk][j] = 0; 			/* a "null" value */ 
    }

    /* then set them */ 
    for(k=0; k<heap->groupFour.numberOfBodies; ++k )	/* loop on "bodies" */ 
    {
	if (k != NUTATIONS) 	/* 0-10 == "bodies" 1-11, real bodies */ 
	  components = 3;	/* xyz; for planets */ 
	else 			/* 11 == "body" 12, nutations; not a real body */
	  components = 2; 	/* dpsi, deps; for nutations */ 

	first = heap->groupSeven.first[k];	
	size  = heap->groupSeven.ncoeffs[k]; 
	next = first + size; 
	
	for ( kk=0; kk<heap->groupSeven.nintervals[k]; ++kk)  /* sub-intervals */ 
	{
	    /* note bodies are numbered 1-11 (jpl's convention), 
	       but indexed 0-10 (c-convention): */ 
	    /*	    printf(" body %d, set %d \n", k+1, kk ); */

	    for ( j=0; j<components; ++j)	/* loop on components */
	    {
		heap->index[k][kk][j] = first; 
		if( first < 0 || first > DATASIZE)
		{
		    printf(" first seems bad (%d); body %d subint %d component %d \n", 
			   first, k, kk, j ); 
		    abort();
		}
		first = next; 
		next = first + heap->groupSeven.ncoeffs[k]; 
	    }
	}
    }

    return 1; 

}


