
#include "../include/f2c.h"

/* Table of constant values */

static doublereal c_b2 = 1.;
static doublereal c_b3 = 1.296e6;

/*  usno nutation subroutines taken from novas.f, */
/*          naval observatory vectorial astronomy subroutines */
/*   only the first is actually called; the others are just here */
/*     (Andrew Porter, porter@s1.gov, 1994/12/28) */

int nod_(t, dpsi, deps)
doublereal *t, *dpsi, *deps;
{
    /* Initialized data */

    static doublereal seccon = 206264.8062470964;
    static struct {
	real e_1[954];
	} equiv_10 = { (double)0., (double)0., (double)0., (double)0., (double)1., 
		(double)-171996., (double)-174.2, (double)92025., (double)8.9, (
		double)0., (double)0., (double)2., (double)-2., (double)2., (double)
		-13187., (double)-1.6, (double)5736., (double)-3.1, (double)0., (
		double)0., (double)2., (double)0., (double)2., (double)-2274., (
		double)-.2, (double)977., (double)-.5, (double)0., (double)0., (
		double)0., (double)0., (double)2., (double)2062., (double).2, (
		double)-895., (double).5, (double)0., (double)1., (double)0., (
		double)0., (double)0., (double)1426., (double)-3.4, (double)54., (
		double)-.1, (double)1., (double)0., (double)0., (double)0., (double)
		0., (double)712., (double).1, (double)-7., (double)0., (double)0., 
		(double)1., (double)2., (double)-2., (double)2., (double)-517., (
		double)1.2, (double)224., (double)-.6, (double)0., (double)0., (
		double)2., (double)0., (double)1., (double)-386., (double)-.4, (
		double)200., (double)0., (double)1., (double)0., (double)2., (
		double)0., (double)2., (double)-301., (double)0., (double)129., (
		double)-.1, (double)0., (double)-1., (double)2., (double)-2., (
		double)2., (double)217., (double)-.5, (double)-95., (double).3, (
		double)1., (double)0., (double)0., (double)-2., (double)0., (double)
		-158., (double)0., (double)-1., (double)0., (double)0., (double)0.,
		 (double)2., (double)-2., (double)1., (double)129., (double).1, (
		double)-70., (double)0., (double)-1., (double)0., (double)2., (
		double)0., (double)2., (double)123., (double)0., (double)-53., (
		double)0., (double)1., (double)0., (double)0., (double)0., (double)
		1., (double)63., (double).1, (double)-33., (double)0., (double)0., 
		(double)0., (double)0., (double)2., (double)0., (double)63., (
		double)0., (double)-2., (double)0., (double)-1., (double)0., (
		double)2., (double)2., (double)2., (double)-59., (double)0., (
		double)26., (double)0., (double)-1., (double)0., (double)0., (
		double)0., (double)1., (double)-58., (double)-.1, (double)32., (
		double)0., (double)1., (double)0., (double)2., (double)0., (double)
		1., (double)-51., (double)0., (double)27., (double)0., (double)2., 
		(double)0., (double)0., (double)-2., (double)0., (double)48., (
		double)0., (double)1., (double)0., (double)-2., (double)0., (double)
		2., (double)0., (double)1., (double)46., (double)0., (double)-24., 
		(double)0., (double)0., (double)0., (double)2., (double)2., (double)
		2., (double)-38., (double)0., (double)16., (double)0., (double)2., 
		(double)0., (double)2., (double)0., (double)2., (double)-31., (
		double)0., (double)13., (double)0., (double)2., (double)0., (double)
		0., (double)0., (double)0., (double)29., (double)0., (double)-1., (
		double)0., (double)1., (double)0., (double)2., (double)-2., (double)
		2., (double)29., (double)0., (double)-12., (double)0., (double)0., 
		(double)0., (double)2., (double)0., (double)0., (double)26., (
		double)0., (double)-1., (double)0., (double)0., (double)0., (double)
		2., (double)-2., (double)0., (double)-22., (double)0., (double)0., 
		(double)0., (double)-1., (double)0., (double)2., (double)0., (
		double)1., (double)21., (double)0., (double)-10., (double)0., (
		double)0., (double)2., (double)0., (double)0., (double)0., (double)
		17., (double)-.1, (double)0., (double)0., (double)0., (double)2., (
		double)2., (double)-2., (double)2., (double)-16., (double).1, (
		double)7., (double)0., (double)-1., (double)0., (double)0., (double)
		2., (double)1., (double)16., (double)0., (double)-8., (double)0., (
		double)0., (double)1., (double)0., (double)0., (double)1., (double)
		-15., (double)0., (double)9., (double)0., (double)1., (double)0., (
		double)0., (double)-2., (double)1., (double)-13., (double)0., (
		double)7., (double)0., (double)0., (double)-1., (double)0., (double)
		0., (double)1., (double)-12., (double)0., (double)6., (double)0., (
		double)2., (double)0., (double)-2., (double)0., (double)0., (double)
		11., (double)0., (double)0., (double)0., (double)-1., (double)0., (
		double)2., (double)2., (double)1., (double)-10., (double)0., (
		double)5., (double)0., (double)1., (double)0., (double)2., (double)
		2., (double)2., (double)-8., (double)0., (double)3., (double)0., (
		double)0., (double)-1., (double)2., (double)0., (double)2., (double)
		-7., (double)0., (double)3., (double)0., (double)0., (double)0., (
		double)2., (double)2., (double)1., (double)-7., (double)0., (double)
		3., (double)0., (double)1., (double)1., (double)0., (double)-2., (
		double)0., (double)-7., (double)0., (double)0., (double)0., (double)
		0., (double)1., (double)2., (double)0., (double)2., (double)7., (
		double)0., (double)-3., (double)0., (double)-2., (double)0., (
		double)0., (double)2., (double)1., (double)-6., (double)0., (double)
		3., (double)0., (double)0., (double)0., (double)0., (double)2., (
		double)1., (double)-6., (double)0., (double)3., (double)0., (double)
		2., (double)0., (double)2., (double)-2., (double)2., (double)6., (
		double)0., (double)-3., (double)0., (double)1., (double)0., (double)
		0., (double)2., (double)0., (double)6., (double)0., (double)0., (
		double)0., (double)1., (double)0., (double)2., (double)-2., (double)
		1., (double)6., (double)0., (double)-3., (double)0., (double)0., (
		double)0., (double)0., (double)-2., (double)1., (double)-5., (
		double)0., (double)3., (double)0., (double)0., (double)-1., (double)
		2., (double)-2., (double)1., (double)-5., (double)0., (double)3., (
		double)0., (double)2., (double)0., (double)2., (double)0., (double)
		1., (double)-5., (double)0., (double)3., (double)0., (double)1., (
		double)-1., (double)0., (double)0., (double)0., (double)5., (double)
		0., (double)0., (double)0., (double)1., (double)0., (double)0., (
		double)-1., (double)0., (double)-4., (double)0., (double)0., (
		double)0., (double)0., (double)0., (double)0., (double)1., (double)
		0., (double)-4., (double)0., (double)0., (double)0., (double)0., (
		double)1., (double)0., (double)-2., (double)0., (double)-4., (
		double)0., (double)0., (double)0., (double)1., (double)0., (double)
		-2., (double)0., (double)0., (double)4., (double)0., (double)0., (
		double)0., (double)2., (double)0., (double)0., (double)-2., (double)
		1., (double)4., (double)0., (double)-2., (double)0., (double)0., (
		double)1., (double)2., (double)-2., (double)1., (double)4., (double)
		0., (double)-2., (double)0., (double)1., (double)1., (double)0., (
		double)0., (double)0., (double)-3., (double)0., (double)0., (double)
		0., (double)1., (double)-1., (double)0., (double)-1., (double)0., (
		double)-3., (double)0., (double)0., (double)0., (double)-1., (
		double)-1., (double)2., (double)2., (double)2., (double)-3., (
		double)0., (double)1., (double)0., (double)0., (double)-1., (double)
		2., (double)2., (double)2., (double)-3., (double)0., (double)1., (
		double)0., (double)1., (double)-1., (double)2., (double)0., (double)
		2., (double)-3., (double)0., (double)1., (double)0., (double)3., (
		double)0., (double)2., (double)0., (double)2., (double)-3., (double)
		0., (double)1., (double)0., (double)-2., (double)0., (double)2., (
		double)0., (double)2., (double)-3., (double)0., (double)1., (double)
		0., (double)1., (double)0., (double)2., (double)0., (double)0., (
		double)3., (double)0., (double)0., (double)0., (double)-1., (double)
		0., (double)2., (double)4., (double)2., (double)-2., (double)0., (
		double)1., (double)0., (double)1., (double)0., (double)0., (double)
		0., (double)2., (double)-2., (double)0., (double)1., (double)0., (
		double)-1., (double)0., (double)2., (double)-2., (double)1., (
		double)-2., (double)0., (double)1., (double)0., (double)0., (double)
		-2., (double)2., (double)-2., (double)1., (double)-2., (double)0., 
		(double)1., (double)0., (double)-2., (double)0., (double)0., (
		double)0., (double)1., (double)-2., (double)0., (double)1., (double)
		0., (double)2., (double)0., (double)0., (double)0., (double)1., (
		double)2., (double)0., (double)-1., (double)0., (double)3., (double)
		0., (double)0., (double)0., (double)0., (double)2., (double)0., (
		double)0., (double)0., (double)1., (double)1., (double)2., (double)
		0., (double)2., (double)2., (double)0., (double)-1., (double)0., (
		double)0., (double)0., (double)2., (double)1., (double)2., (double)
		2., (double)0., (double)-1., (double)0., (double)1., (double)0., (
		double)0., (double)2., (double)1., (double)-1., (double)0., (double)
		0., (double)0., (double)1., (double)0., (double)2., (double)2., (
		double)1., (double)-1., (double)0., (double)1., (double)0., (double)
		1., (double)1., (double)0., (double)-2., (double)1., (double)-1., (
		double)0., (double)0., (double)0., (double)0., (double)1., (double)
		0., (double)2., (double)0., (double)-1., (double)0., (double)0., (
		double)0., (double)0., (double)1., (double)2., (double)-2., (double)
		0., (double)-1., (double)0., (double)0., (double)0., (double)0., (
		double)1., (double)-2., (double)2., (double)0., (double)-1., (
		double)0., (double)0., (double)0., (double)1., (double)0., (double)
		-2., (double)2., (double)0., (double)-1., (double)0., (double)0., (
		double)0., (double)1., (double)0., (double)-2., (double)-2., (
		double)0., (double)-1., (double)0., (double)0., (double)0., (double)
		1., (double)0., (double)2., (double)-2., (double)0., (double)-1., (
		double)0., (double)0., (double)0., (double)1., (double)0., (double)
		0., (double)-4., (double)0., (double)-1., (double)0., (double)0., (
		double)0., (double)2., (double)0., (double)0., (double)-4., (double)
		0., (double)-1., (double)0., (double)0., (double)0., (double)0., (
		double)0., (double)2., (double)4., (double)2., (double)-1., (double)
		0., (double)0., (double)0., (double)0., (double)0., (double)2., (
		double)-1., (double)2., (double)-1., (double)0., (double)0., (
		double)0., (double)-2., (double)0., (double)2., (double)4., (double)
		2., (double)-1., (double)0., (double)1., (double)0., (double)2., (
		double)0., (double)2., (double)2., (double)2., (double)-1., (double)
		0., (double)0., (double)0., (double)0., (double)-1., (double)2., (
		double)0., (double)1., (double)-1., (double)0., (double)0., (double)
		0., (double)0., (double)0., (double)-2., (double)0., (double)1., (
		double)-1., (double)0., (double)0., (double)0., (double)0., (double)
		0., (double)4., (double)-2., (double)2., (double)1., (double)0., (
		double)0., (double)0., (double)0., (double)1., (double)0., (double)
		0., (double)2., (double)1., (double)0., (double)0., (double)0., (
		double)1., (double)1., (double)2., (double)-2., (double)2., (double)
		1., (double)0., (double)-1., (double)0., (double)3., (double)0., (
		double)2., (double)-2., (double)2., (double)1., (double)0., (double)
		0., (double)0., (double)-2., (double)0., (double)2., (double)2., (
		double)2., (double)1., (double)0., (double)-1., (double)0., (double)
		-1., (double)0., (double)0., (double)0., (double)2., (double)1., (
		double)0., (double)-1., (double)0., (double)0., (double)0., (double)
		-2., (double)2., (double)1., (double)1., (double)0., (double)0., (
		double)0., (double)0., (double)1., (double)2., (double)0., (double)
		1., (double)1., (double)0., (double)0., (double)0., (double)-1., (
		double)0., (double)4., (double)0., (double)2., (double)1., (double)
		0., (double)0., (double)0., (double)2., (double)1., (double)0., (
		double)-2., (double)0., (double)1., (double)0., (double)0., (double)
		0., (double)2., (double)0., (double)0., (double)2., (double)0., (
		double)1., (double)0., (double)0., (double)0., (double)2., (double)
		0., (double)2., (double)-2., (double)1., (double)1., (double)0., (
		double)-1., (double)0., (double)2., (double)0., (double)-2., (
		double)0., (double)1., (double)1., (double)0., (double)0., (double)
		0., (double)1., (double)-1., (double)0., (double)-2., (double)0., (
		double)1., (double)0., (double)0., (double)0., (double)-1., (double)
		0., (double)0., (double)1., (double)1., (double)1., (double)0., (
		double)0., (double)0., (double)-1., (double)-1., (double)0., (
		double)2., (double)1., (double)1., (double)0., (double)0., (double)
		0., (double)0., (double)1., (double)0., (double)1., (double)0., (
		double)1., (double)0., (double)0., (double)0. };


    /* System generated locals */
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double d_mod(), sin(), cos();

    /* Local variables */
    static doublereal d, f;
    static integer i, j;
    static doublereal l;
#define x ((real *)&equiv_10)
#define x1 ((real *)&equiv_10)
#define x2 ((real *)&equiv_10 + 90)
#define x3 ((real *)&equiv_10 + 180)
#define x4 ((real *)&equiv_10 + 270)
#define x5 ((real *)&equiv_10 + 360)
#define x6 ((real *)&equiv_10 + 450)
#define x7 ((real *)&equiv_10 + 540)
#define x8 ((real *)&equiv_10 + 630)
#define x9 ((real *)&equiv_10 + 720)
#define xa ((real *)&equiv_10 + 810)
#define xb ((real *)&equiv_10 + 900)
    static doublereal lp, om, arg;


/*     this subroutine evaluates the nutation series and returns the */
/*     values for nutation in longitude and nutation in obliquity. */
/*     wahr nutation series for axis b for gilbert & dziewonski earth */
/*     model 1066a. */
/*     1980 iau theory of nutation. */

/*          t    = tdb time in julian centuries since j2000.0 (in) */
/*          dpsi = nutation in longitude in seconds of arc (out) */
/*          deps = nutation in obliquity in seconds of arc (out) */



/* ***********************************************************************
 */


/*     table of multiples of arguments and coefficients */

/*                   multiple of            longitude        obliquity */
/*              l    l'   f    d  omega   coeff. of sin    coeff. of cos 
*/

/* ***********************************************************************
 */


/*     computation of  fundamental arguments */


    d__1 = ((*t * .064 + 31.31) * *t + 715922.633) * *t + 485866.733;
    d__2 = *t * 1325.;
    l = d__1 + d_mod(&d__2, &c_b2) * 1.296e6;
    l = d_mod(&l, &c_b3);

    d__1 = ((*t * -.012 - .577) * *t + 1292581.224) * *t + 1287099.804;
    d__2 = *t * 99.;
    lp = d__1 + d_mod(&d__2, &c_b2) * 1.296e6;
    lp = d_mod(&lp, &c_b3);

    d__1 = ((*t * .011 - 13.257) * *t + 295263.137) * *t + 335778.877;
    d__2 = *t * 1342.;
    f = d__1 + d_mod(&d__2, &c_b2) * 1.296e6;
    f = d_mod(&f, &c_b3);

    d__1 = ((*t * .019 - 6.891) * *t + 1105601.328) * *t + 1072261.307;
    d__2 = *t * 1236.;
    d = d__1 + d_mod(&d__2, &c_b2) * 1.296e6;
    d = d_mod(&d, &c_b3);

    d__1 = *t * 5.;
    om = ((*t * .008 + 7.455) * *t - 482890.539) * *t + 450160.28 - d_mod(&
	    d__1, &c_b2) * 1.296e6;
    om = d_mod(&om, &c_b3);

/* ***********************************************************************
 */


    *dpsi = 0.;
    *deps = 0.;

/*     sum nutation series terms, from smallest to largest */

    for (j = 1; j <= 106; ++j) {
	i = 107 - j;
/*     formation of multiples of arguments */
	d__3 = (doublereal) x[i * 9 - 9] * l + (doublereal) x[i * 9 - 8] * lp;
	d__2 = d__3 + (doublereal) x[i * 9 - 7] * f;
	d__1 = d__2 + (doublereal) x[i * 9 - 6] * d;
	arg = d__1 + (doublereal) x[i * 9 - 5] * om;
	arg = d_mod(&arg, &c_b3) / seccon;
/*     evaluate nutation */
	*dpsi = ((doublereal) x[i * 9 - 4] + (doublereal) x[i * 9 - 3] * *t) *
		 sin(arg) + *dpsi;
	*deps = ((doublereal) x[i * 9 - 2] + (doublereal) x[i * 9 - 1] * *t) *
		 cos(arg) + *deps;
/* L10: */
    }


    *dpsi *= 1e-4;
    *deps *= 1e-4;

/* ***********************************************************************
 */


    return 0;
} /* nod_ */

#undef xb
#undef xa
#undef x9
#undef x8
#undef x7
#undef x6
#undef x5
#undef x4
#undef x3
#undef x2
#undef x1
#undef x


