c  usno nutation subroutines taken from novas.f, 
c          naval observatory vectorial astronomy subroutines 
c   only the first is actually called; the others are just here
c     (Andrew Porter, porter@s1.gov, 1994/12/28)
c  
      subroutine nod (t,dpsi,deps)                                              
c                                                                               
c     this subroutine evaluates the nutation series and returns the             
c     values for nutation in longitude and nutation in obliquity.               
c     wahr nutation series for axis b for gilbert & dziewonski earth            
c     model 1066a.                                                              
c     1980 iau theory of nutation.                                              
c                                                                               
c          t    = tdb time in julian centuries since j2000.0 (in)               
c          dpsi = nutation in longitude in seconds of arc (out)                 
c          deps = nutation in obliquity in seconds of arc (out)                 
c                                                                               
c                                                                               
      double precision t,dpsi,deps,seccon,l,lp,f,d,om,arg,dmod,dble,            
     /     dsin,dcos                                                            
      dimension x(9,106),x1(90),x2(90),x3(90),x4(90),x5(90),x6(90),             
     /     x7(90),x8(90),x9(90),xa(90),xb(54)                                   
      equivalence(x(1,  1),x1(1))                                               
      equivalence(x(1, 11),x2(1))                                               
      equivalence(x(1, 21),x3(1))                                               
      equivalence(x(1, 31),x4(1))                                               
      equivalence(x(1, 41),x5(1))                                               
      equivalence(x(1, 51),x6(1))                                               
      equivalence(x(1, 61),x7(1))                                               
      equivalence(x(1, 71),x8(1))                                               
      equivalence(x(1, 81),x9(1))                                               
      equivalence(x(1, 91),xa(1))                                               
      equivalence(x(1,101),xb(1))                                               
      data seccon/206264.8062470964d0/                                          
c                                                                               
c***********************************************************************        
c                                                                               
c                                                                               
c     table of multiples of arguments and coefficients                          
c                                                                               
c                   multiple of            longitude        obliquity           
c              l    l'   f    d  omega   coeff. of sin    coeff. of cos         
      data x1/ 0.,  0.,  0.,  0.,  1., -171996., -174.2,  92025.,  8.9,         
     /         0.,  0.,  2., -2.,  2.,  -13187.,   -1.6,   5736., -3.1,         
     /         0.,  0.,  2.,  0.,  2.,   -2274.,   -0.2,    977., -0.5,         
     /         0.,  0.,  0.,  0.,  2.,    2062.,    0.2,   -895.,  0.5,         
     /         0.,  1.,  0.,  0.,  0.,    1426.,   -3.4,     54., -0.1,         
     /         1.,  0.,  0.,  0.,  0.,     712.,    0.1,     -7.,  0.0,         
     /         0.,  1.,  2., -2.,  2.,    -517.,    1.2,    224., -0.6,         
     /         0.,  0.,  2.,  0.,  1.,    -386.,   -0.4,    200.,  0.0,         
     /         1.,  0.,  2.,  0.,  2.,    -301.,    0.0,    129., -0.1,         
     /         0., -1.,  2., -2.,  2.,     217.,   -0.5,    -95.,  0.3/         
      data x2/ 1.,  0.,  0., -2.,  0.,    -158.,    0.0,     -1.,  0.0,         
     /         0.,  0.,  2., -2.,  1.,     129.,    0.1,    -70.,  0.0,         
     /        -1.,  0.,  2.,  0.,  2.,     123.,    0.0,    -53.,  0.0,         
     /         1.,  0.,  0.,  0.,  1.,      63.,    0.1,    -33.,  0.0,         
     /         0.,  0.,  0.,  2.,  0.,      63.,    0.0,     -2.,  0.0,         
     /        -1.,  0.,  2.,  2.,  2.,     -59.,    0.0,     26.,  0.0,         
     /        -1.,  0.,  0.,  0.,  1.,     -58.,   -0.1,     32.,  0.0,         
     /         1.,  0.,  2.,  0.,  1.,     -51.,    0.0,     27.,  0.0,         
     /         2.,  0.,  0., -2.,  0.,      48.,    0.0,      1.,  0.0,         
     /        -2.,  0.,  2.,  0.,  1.,      46.,    0.0,    -24.,  0.0/         
      data x3/ 0.,  0.,  2.,  2.,  2.,     -38.,    0.0,     16.,  0.0,         
     /         2.,  0.,  2.,  0.,  2.,     -31.,    0.0,     13.,  0.0,         
     /         2.,  0.,  0.,  0.,  0.,      29.,    0.0,     -1.,  0.0,         
     /         1.,  0.,  2., -2.,  2.,      29.,    0.0,    -12.,  0.0,         
     /         0.,  0.,  2.,  0.,  0.,      26.,    0.0,     -1.,  0.0,         
     /         0.,  0.,  2., -2.,  0.,     -22.,    0.0,      0.,  0.0,         
     /        -1.,  0.,  2.,  0.,  1.,      21.,    0.0,    -10.,  0.0,         
     /         0.,  2.,  0.,  0.,  0.,      17.,   -0.1,      0.,  0.0,         
     /         0.,  2.,  2., -2.,  2.,     -16.,    0.1,      7.,  0.0,         
     /        -1.,  0.,  0.,  2.,  1.,      16.,    0.0,     -8.,  0.0/         
      data x4/ 0.,  1.,  0.,  0.,  1.,     -15.,    0.0,      9.,  0.0,         
     /         1.,  0.,  0., -2.,  1.,     -13.,    0.0,      7.,  0.0,         
     /         0., -1.,  0.,  0.,  1.,     -12.,    0.0,      6.,  0.0,         
     /         2.,  0., -2.,  0.,  0.,      11.,    0.0,      0.,  0.0,         
     /        -1.,  0.,  2.,  2.,  1.,     -10.,    0.0,      5.,  0.0,         
     /         1.,  0.,  2.,  2.,  2.,      -8.,    0.0,      3.,  0.0,         
     /         0., -1.,  2.,  0.,  2.,      -7.,    0.0,      3.,  0.0,         
     /         0.,  0.,  2.,  2.,  1.,      -7.,    0.0,      3.,  0.0,         
     /         1.,  1.,  0., -2.,  0.,      -7.,    0.0,      0.,  0.0,         
     /         0.,  1.,  2.,  0.,  2.,       7.,    0.0,     -3.,  0.0/         
      data x5/-2.,  0.,  0.,  2.,  1.,      -6.,    0.0,      3.,  0.0,         
     /         0.,  0.,  0.,  2.,  1.,      -6.,    0.0,      3.,  0.0,         
     /         2.,  0.,  2., -2.,  2.,       6.,    0.0,     -3.,  0.0,         
     /         1.,  0.,  0.,  2.,  0.,       6.,    0.0,      0.,  0.0,         
     /         1.,  0.,  2., -2.,  1.,       6.,    0.0,     -3.,  0.0,         
     /         0.,  0.,  0., -2.,  1.,      -5.,    0.0,      3.,  0.0,         
     /         0., -1.,  2., -2.,  1.,      -5.,    0.0,      3.,  0.0,         
     /         2.,  0.,  2.,  0.,  1.,      -5.,    0.0,      3.,  0.0,         
     /         1., -1.,  0.,  0.,  0.,       5.,    0.0,      0.,  0.0,         
     /         1.,  0.,  0., -1.,  0.,      -4.,    0.0,      0.,  0.0/         
      data x6/ 0.,  0.,  0.,  1.,  0.,      -4.,    0.0,      0.,  0.0,         
     /         0.,  1.,  0., -2.,  0.,      -4.,    0.0,      0.,  0.0,         
     /         1.,  0., -2.,  0.,  0.,       4.,    0.0,      0.,  0.0,         
     /         2.,  0.,  0., -2.,  1.,       4.,    0.0,     -2.,  0.0,         
     /         0.,  1.,  2., -2.,  1.,       4.,    0.0,     -2.,  0.0,         
     /         1.,  1.,  0.,  0.,  0.,      -3.,    0.0,      0.,  0.0,         
     /         1., -1.,  0., -1.,  0.,      -3.,    0.0,      0.,  0.0,         
     /        -1., -1.,  2.,  2.,  2.,      -3.,    0.0,      1.,  0.0,         
     /         0., -1.,  2.,  2.,  2.,      -3.,    0.0,      1.,  0.0,         
     /         1., -1.,  2.,  0.,  2.,      -3.,    0.0,      1.,  0.0/         
      data x7/ 3.,  0.,  2.,  0.,  2.,      -3.,    0.0,      1.,  0.0,         
     /        -2.,  0.,  2.,  0.,  2.,      -3.,    0.0,      1.,  0.0,         
     /         1.,  0.,  2.,  0.,  0.,       3.,    0.0,      0.,  0.0,         
     /        -1.,  0.,  2.,  4.,  2.,      -2.,    0.0,      1.,  0.0,         
     /         1.,  0.,  0.,  0.,  2.,      -2.,    0.0,      1.,  0.0,         
     /        -1.,  0.,  2., -2.,  1.,      -2.,    0.0,      1.,  0.0,         
     /         0., -2.,  2., -2.,  1.,      -2.,    0.0,      1.,  0.0,         
     /        -2.,  0.,  0.,  0.,  1.,      -2.,    0.0,      1.,  0.0,         
     /         2.,  0.,  0.,  0.,  1.,       2.,    0.0,     -1.,  0.0,         
     /         3.,  0.,  0.,  0.,  0.,       2.,    0.0,      0.,  0.0/         
      data x8/ 1.,  1.,  2.,  0.,  2.,       2.,    0.0,     -1.,  0.0,         
     /         0.,  0.,  2.,  1.,  2.,       2.,    0.0,     -1.,  0.0,         
     /         1.,  0.,  0.,  2.,  1.,      -1.,    0.0,      0.,  0.0,         
     /         1.,  0.,  2.,  2.,  1.,      -1.,    0.0,      1.,  0.0,         
     /         1.,  1.,  0., -2.,  1.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  1.,  0.,  2.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  1.,  2., -2.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  1., -2.,  2.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         1.,  0., -2.,  2.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         1.,  0., -2., -2.,  0.,      -1.,    0.0,      0.,  0.0/         
      data x9/ 1.,  0.,  2., -2.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         1.,  0.,  0., -4.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         2.,  0.,  0., -4.,  0.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  0.,  2.,  4.,  2.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  0.,  2., -1.,  2.,      -1.,    0.0,      0.,  0.0,         
     /        -2.,  0.,  2.,  4.,  2.,      -1.,    0.0,      1.,  0.0,         
     /         2.,  0.,  2.,  2.,  2.,      -1.,    0.0,      0.,  0.0,         
     /         0., -1.,  2.,  0.,  1.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  0., -2.,  0.,  1.,      -1.,    0.0,      0.,  0.0,         
     /         0.,  0.,  4., -2.,  2.,       1.,    0.0,      0.,  0.0/         
      data xa/ 0.,  1.,  0.,  0.,  2.,       1.,    0.0,      0.,  0.0,         
     /         1.,  1.,  2., -2.,  2.,       1.,    0.0,     -1.,  0.0,         
     /         3.,  0.,  2., -2.,  2.,       1.,    0.0,      0.,  0.0,         
     /        -2.,  0.,  2.,  2.,  2.,       1.,    0.0,     -1.,  0.0,         
     /        -1.,  0.,  0.,  0.,  2.,       1.,    0.0,     -1.,  0.0,         
     /         0.,  0., -2.,  2.,  1.,       1.,    0.0,      0.,  0.0,         
     /         0.,  1.,  2.,  0.,  1.,       1.,    0.0,      0.,  0.0,         
     /        -1.,  0.,  4.,  0.,  2.,       1.,    0.0,      0.,  0.0,         
     /         2.,  1.,  0., -2.,  0.,       1.,    0.0,      0.,  0.0,         
     /         2.,  0.,  0.,  2.,  0.,       1.,    0.0,      0.,  0.0/         
      data xb/ 2.,  0.,  2., -2.,  1.,       1.,    0.0,     -1.,  0.0,         
     /         2.,  0., -2.,  0.,  1.,       1.,    0.0,      0.,  0.0,         
     /         1., -1.,  0., -2.,  0.,       1.,    0.0,      0.,  0.0,         
     /        -1.,  0.,  0.,  1.,  1.,       1.,    0.0,      0.,  0.0,         
     /        -1., -1.,  0.,  2.,  1.,       1.,    0.0,      0.,  0.0,         
     /         0.,  1.,  0.,  1.,  0.,       1.,    0.0,      0.,  0.0/         
c                                                                               
c***********************************************************************        
c                                                                               
c                                                                               
c     computation of  fundamental arguments                                     
c                                                                               
c                                                                               
      l = ((+0.064d0 * t + 31.310d0) * t + 715922.633d0) * t                    
     /     + 485866.733d0 + dmod(1325.0d0*t,1.0d0) * 1296000.0d0                
      l = dmod(l,1296000.0d0)                                                   
c                                                                               
      lp = ((-0.012d0 * t - 0.577d0) * t + 1292581.224d0) * t                   
     /     + 1287099.804d00 + dmod(99.0d0*t,1.0d0) * 1296000.0d0                
      lp = dmod(lp,1296000.0d0)                                                 
c                                                                               
      f = ((+0.011d0 * t - 13.257d0) * t + 295263.137d0) * t                    
     /     + 335778.877d0 + dmod(1342.0d0*t,1.0d0) * 1296000.0d0                
      f = dmod(f,1296000.0d0)                                                   
c                                                                               
      d = ((+0.019d0 * t - 6.891d0) * t + 1105601.328d0) * t                    
     /     + 1072261.307d0 + dmod(1236.0d0*t,1.0d0) * 1296000.0d0               
      d = dmod(d,1296000.0d0)                                                   
c                                                                               
      om = ((0.008d0 * t + 7.455d0) * t - 482890.539d0) * t                     
     /     + 450160.280d0  - dmod(5.0d0*t,1.0d0) * 1296000.0d0                  
      om = dmod(om,1296000.0d0)                                                 
c                                                                               
c***********************************************************************        
c                                                                               
c                                                                               
      dpsi = 0.d0                                                               
      deps = 0.d0                                                               
c                                                                               
c     sum nutation series terms, from smallest to largest                       
c                                                                               
      do 10 j=1,106                                                             
      i = 107 - j                                                               
c     formation of multiples of arguments                                       
      arg = dble(x(1,i)) * l                                                    
     /    + dble(x(2,i)) * lp                                                   
     /    + dble(x(3,i)) * f                                                    
     /    + dble(x(4,i)) * d                                                    
     /    + dble(x(5,i)) * om                                                   
      arg = dmod(arg,1296000.0d0) / seccon                                      
c     evaluate nutation                                                         
      dpsi = (dble(x(6,i)) + dble(x(7,i))*t) * dsin(arg) + dpsi                 
      deps = (dble(x(8,i)) + dble(x(9,i))*t) * dcos(arg) + deps                 
   10 continue                                                                  
c                                                                               
c                                                                               
      dpsi = dpsi * 1.0d-4                                                      
      deps = deps * 1.0d-4                                                      
c                                                                               
c***********************************************************************        
c                                                                               
c                                                                               
      return                                                                    
      end                                                                       
