/* planetx.c provides orbit for planet X 
 * 91/09/17; but code is older than this file
 * a. porter
 * source of the orbit is noted below -- 
 * the planet X conjecture has since been more or less 
 * convincingly undermined,
 * but the orbit is included here for your amusement.
 * possibly useful for science-fiction purposes ... 
 * source: R. S. Harrington, Astron. J. 96 (1988) 1476  
 *
 * 94/09/22 / a. porter
 */

#define LANGUAGE_C
#include <stdio.h>
#include <math.h>

#include "../include/ms.h" 
#include "../include/matrix.h"
#include "../include/hnav.h"



void 
planetx( orb, utime )
     Orbit *orb;	/* where to put the orbit */
     double utime;	/* reference time for the orbit */
{
    double	ecc;		/* eccentricity */
    double 	axis;		/* axis */
    double 	node;		/* asc. node */
    double 	incl;		/* inclination */
    double 	pgee;		/* arg. of perihelion  */

    double	ptimea;		/* perihelion time */ 
    double	ptimeb;		/* perihelion time */ 
    double 	jdperi;		/* jd of perihelion */ 
    double	meanmotion;	/* mean motion */  

    /* Planet X */
    ecc 	= 0.411;
    axis	= 101.2;		/* AU */
    node	= 275.4;		/* degrees */
    incl	= 32.4;			/* degrees */
    pgee	= 208.5;		/* degrees */ 

    orb->o_mass 	= SUN_MASS;
    orb->o_eccen 	= ecc;

    orb->o_axis  	= axis * AU; 
    meanmotion = sqrt( BIG_G * SUN_MASS / (orb->o_axis * orb->o_axis * orb->o_axis) ); 

    orb->o_er.er_1 = node*TORADIANS;
    orb->o_er.er_2 = incl*TORADIANS;
    orb->o_er.er_3 = pgee*TORADIANS;

    /* perihelion was 6 August, 1789; 
       1800.0 = jd 2378496.5  (Explanatory Supplement, p. 437)
       1789.0 = jd 1800 - 9*365 - 2*366
              = 2378496.5 - 4017. = 2374479.5;
       aug 6 = jan 1 + 217
       so 1798/08/06 = jd 2374696.5;
       noon is jd 2374697.0 
     */

    ptimea = gmta( 1789, 8, 6, 12, 0, 0.0 ); 

    orb->o_periTime = ptimea; 
    orb->o_refTime =     orb->o_periTime;
    orb->o_refAnomaly = 0.; 
    
}
